PHPIrc_bot - (c) 2006 Thorben Gartmann - type "less $PATH_TO_PHPIrc_bot/GPL" for more info. 
<?php
/*
PHPIrc_bot - an IRC bot writen in PHP
Copyright (C) 2006 Thorben Gartmann

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

include_once("IRC.php");

class IRC_Bot {
    public $server;
    public $port = 6667;
    
    public $nickname = "PHPIrc_Bot";
    public $username = "PHPIrc_Bot";
    public $hostname = "HOST";
    public $servername = "SERVER";
    public $realname = "Botti der Bot";
    
    public $irc;

    private $hooks = array();
    private $privmsg_hooks = array();

    function run() {
        $this->irc = IRC::factory($this->server,
                                  $this->port,
                                  $this->nickname,
                                  $this->username,
                                  $this->servername,
                                  $this->realname);
        
        while (true) {
            $input = $this->irc->get();
            $this->do_hooks($input);
        }
    }

    function add_hook($command, $function) {
        $this->hooks[] = array("command" => $command, "function" => $function);
    }

    function add_privmsg_hook($command, $function, $channel = "*") {
        $this->privmsg_hooks[] = array("command" => $command, "function" => $function, "channel" => $channel);
    }

    function do_hooks($input) {
        foreach ($this->hooks AS $hook) {
            if ($hook["command"] == $input["command"]) {
                call_user_func($hook["function"],
                               $this->irc,
                               $input["command"],
                               $input["params"],
                               $input["prefix"]);
            }
        }
        
        if ($input["command"] == "PRIVMSG") {
            foreach ($this->privmsg_hooks AS $hook) {
                $string = $hook["channel"] . " :" . $hook["command"];
                $string2 = strstr($input["params"], ":");
                if ($hook["channel"] != "*" &&
                    substr($input["params"], 0, strlen($string)) == $string) { 
                    call_user_func($hook["function"],
                                   $this->irc,
                                   substr($input["params"], strlen($string) + 1),
                                   $input["prefix"],
                                   $hook["channel"]);
                } elseif (substr($string2, 0, strlen($hook["command"]) + 1) == ":" . $hook["command"]) {
                    $params_pos = @strpos($input["params"], $hook["command"]) + strlen($hook["command"]) + 1;
                    $params = substr($input["params"], $params_pos);
                    $channel = substr($input["params"], 0, strpos($input["params"], " "));
                    call_user_func($hook["function"],
                                   $this->irc,
                                   $params,
                                   $input["prefix"],
                                   $channel);

                }
            }
        }
    }
}

?>
