<?php
/*
PHPIrc_bot - an IRC bot writen in PHP
Copyright (C) 2006 Thorben Gartmann

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


include("BOT.php");

$bot = new IRC_Bot;

// Config for the bot
$bot->server = "irc.hes.de.euirc.net";
$bot->port = "6667";
$bot->nickname = "php4youBot";

// Some config for hooks
$owner = "boxxar";
$quitmsg = "Cya leute!! >>www.php4you.de<<";
$log_format = "d.m H:i";
$info["owner"] = "boxxar";
$info["website"] = "www.php4you.de";
$info["version"] = "PHPIrc_bot 0.1";
$info["commands"] = "!coffee, !info";

// Write commands in uppercase!!
$bot->add_hook("422", "php4youBot_init");
$bot->add_hook("376", "php4youBot_init");
$bot->add_hook("PRIVMSG", "php4youBot_coffee");
$bot->add_hook("PRIVMSG", "php4youBot_quit");
$bot->add_hook("PRIVMSG", "php4youBot_msglog");
$bot->add_hook("PRIVMSG", "php4youBot_info");

$bot->run();

function php4youBot_init($object, $command, $params, $prefix) {
    $object->join("#php4you");
    $object->action("#php4you", "ist jetzt online");
}

function php4youBot_msglog($object, $command, $params, $prefix) {
    global $log_format;
    
    $nick = IRC::get_nick($prefix);
    $dest = substr($params, 0, strpos($params, " "));
    $msg = substr($params, strpos($params, " :") + 2);
    $file = "logfile";
    file_put_contents($file, date($log_format) . " $dest <$nick> $msg\n", FILE_APPEND);
}

function php4youBot_coffee($object, $command, $params, $prefix) {
    $string = "#php4you :!coffee";
    if (substr($params, 0, strlen($string)) == $string) {
        $nick = IRC::get_nick($prefix);
        $object->privmsg("#php4you", ":Ein Kaffee fuer " . $nick . "? Bitte sehr *kaffeegeb*");
    }
}

function php4youBot_info($object, $command, $params, $prefix) {
    global $info;
    
    $string = "#php4you :!info";
    if (substr($params, 0, strlen($string)) == $string) {
        foreach ($info AS $key=>$value) {
            $object->privmsg("#php4you", ":" . chr(2) . $key . ": " . chr(2) . $value);
        }
    }
}

function php4youBot_quit($object, $command, $params, $prefix) {
    global $owner;
    global $quitmsg;

    $string = "#php4you :!quit";
    $nick = IRC::get_nick($prefix);
    if (substr($params, 0, strlen($string)) == $string && $nick == $owner) { 
        $object->quit(":$quitmsg");
        exit;
    }
}
?>
