<?php
/*
PHPIRC-bot - an IRC bot writen in PHP
Copyright (C) 2006 Thorben Gartmann

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

*/

class IRC { 
    public $server;
    public $port;
    public $nickname;
    public $username;
    public $hosthostname;
    public $servername;
    public $realname;

    private $stack = array();

    private $handle;
    public $errno;
    public $errstr;
    
    static function factory($server, 
                            $port = 6667, 
                            $nick = "phpirc", 
                            $user = "phpirc", 
                            $host = "host", 
                            $servername = "server", 
                            $realname = "php irc") {
        
        // New IRC Object
        $irc = new IRC;
        
        // Save data
        $irc->server = $server;
        $irc->port = $port;
        $irc->nickname = $nick;
        $irc->username = $user;
        $irc->hostname = $host;
        $irc->servername = $servername;
        $irc->realname = $realname;
    
        // Connect to $server with $port
        $irc->connect();
        
        // Register
        $irc->pass(md5(rand(1, 1000)));
        $irc->nick($nick);
        $irc->user($user, $host, $servername, ":" . $realname);
        
        // Return the object
        return $irc;
    }

    function connect() {
        // Connect
        $this->handle = fsockopen($this->server, $this->port, $this->errno, $this->errstr);
        
        // Check if connection is okay.
        if (!is_resource($this->handle)) {
            die("error with connection");
        }
        return 1;
    }

    function __call($command, $params) {
        // Generate data
        $data = strtoupper($command) . " " . implode(" ", $params) . "\n";
        
        // Send data
        fwrite($this->handle, $data);
    }

    function get() { 
        if (empty($this->stack)) {
            // Get data
            $data = fread($this->handle, 100000);
            // Split data
            $data = explode("\n", $data);
            unset($data[count($data) - 1]);
            $this->stack = $data;
        }
        $line = array_shift($this->stack);
        echo $line . "\n";
        return self::analyse($line, $this);
    }

    function action($dest, $text) {
        $this->privmsg($dest, ":" . chr(1) . "ACTION " . $text . chr(1));
    }

    static function analyse($data, $object) {
        // Check if data is empty
        if ($data == "") {
            return 0;
        }
        // Get prefix
        if (substr($data, 0, 1) == ":") {
            $retval["prefix"] = substr($data, 1, strpos($data, " "));
            $data = substr($data, strpos($data, " ") + 1);
        }
        
        // Get command
        $retval["command"] = substr($data, 0, strpos($data, " "));
        $retval["command"] = strtoupper($retval["command"]);
        
        // Get params
        $retval["params"] = substr($data, strpos($data, " ") + 1);
        
        // Response to pings
        if ($retval["command"] == "PING") {
            $object->pong($retval["params"]);
        }
        
        return $retval;
    }

    static function get_nick($prefix) {
        $nick = substr($prefix, 0, strpos($prefix, "!"));
        $nick = str_replace(":", "", $nick);
        return $nick;
    }
}
?>
